/*
 * Decompiled with CFR 0.152.
 */
package com.pfg.mi1robot;

import com.pfg.mi1robot.Bitmap;
import com.pfg.mi1robot.Tablero;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;

public class Robot {
    private ArrayList<Bitmap> robot;
    private int direccion;
    private int X;
    private int Y;
    private int velocidad;
    private int modificador;
    private boolean dormido = false;
    private long hilo = -1L;

    public Robot(ArrayList<Bitmap> robot) {
        this.robot = robot;
        this.direccion = 0;
        this.velocidad = 1;
        this.modificador = 0;
        this.dormido = false;
    }

    public void setRobot(ArrayList<Bitmap> robot) {
        this.robot = robot;
    }

    public ArrayList<Bitmap> getRobot() {
        return this.robot;
    }

    public Bitmap getImagenRobot(int pos) {
        Iterator<Bitmap> iterador = this.robot.iterator();
        int i = 0;
        while (i < pos) {
            iterador.next();
            ++i;
        }
        return iterador.next();
    }

    public void setImagenRobot(Bitmap robotimagen, int pos) {
        ArrayList<Bitmap> aux = new ArrayList<Bitmap>();
        Iterator<Bitmap> iterador = this.robot.iterator();
        int i = 0;
        while (i < pos) {
            aux.add(iterador.next());
            ++i;
        }
        aux.add(robotimagen);
        while (iterador.hasNext()) {
            aux.add(iterador.next());
        }
    }

    public void setDireccion(int direccion) {
        this.direccion = direccion;
    }

    public int getDireccion() {
        return this.direccion;
    }

    public int getX() {
        return this.X;
    }

    public int getY() {
        return this.Y;
    }

    public void setX(int X) {
        this.X = X;
    }

    public void setY(int Y) {
        this.Y = Y;
    }

    public void draw(Graphics g) {
        Iterator<Bitmap> e = this.robot.iterator();
        int i = 0;
        while (i < this.direccion + this.modificador) {
            e.next();
            ++i;
        }
        Bitmap robotdibujar = e.next();
        g.drawImage(robotdibujar.getImagen(), this.X - robotdibujar.getWidth() / 2, this.Y - robotdibujar.getHeight() / 2, null);
    }

    public void mover(int direccion, Tablero tablero) {
        switch (direccion) {
            case 0: {
                this.direccion = 0;
                if (this.getY() + 20 + this.robot.get(0).getHeight() / 2 <= tablero.get_Yescenario()) {
                    this.setY(this.getY() + 20);
                    break;
                }
                this.setY(tablero.get_Yescenario() - this.robot.get(0).getHeight() / 2);
                break;
            }
            case 1: {
                this.direccion = 1;
                if (this.getY() - 20 - this.robot.get(0).getHeight() / 2 >= 0) {
                    this.setY(this.getY() - 20);
                    break;
                }
                this.setY(0 + this.robot.get(0).getHeight() / 2);
                break;
            }
            case 2: {
                this.direccion = 2;
                if (this.getX() - 20 - this.robot.get(0).getWidth() / 2 >= 0) {
                    this.setX(this.getX() - 20);
                    break;
                }
                this.setX(0 + this.robot.get(0).getWidth() / 2);
                break;
            }
            case 3: {
                this.direccion = 3;
                if (this.getY() + 20 + this.robot.get(0).getWidth() / 2 <= tablero.get_Xescenario()) {
                    this.setX(this.getX() + 20);
                    break;
                }
                this.setX(tablero.get_Xescenario() - this.robot.get(0).getWidth() / 2);
            }
        }
    }

    public void saltar(Tablero tablero) {
        switch (this.direccion) {
            case 0: {
                if (this.getY() + 60 + this.robot.get(0).getHeight() / 2 <= tablero.get_Yescenario()) {
                    this.setY(this.getY() + 60);
                    break;
                }
                this.setY(tablero.get_Yescenario() - this.robot.get(0).getHeight() / 2);
                break;
            }
            case 1: {
                if (this.getY() - 60 - this.robot.get(0).getHeight() / 2 >= 0) {
                    this.setY(this.getY() - 60);
                    break;
                }
                this.setY(0 + this.robot.get(0).getHeight() / 2);
                break;
            }
            case 2: {
                if (this.getX() - 60 - this.robot.get(0).getWidth() / 2 >= 0) {
                    this.setX(this.getX() - 60);
                    break;
                }
                this.setX(0 + this.robot.get(0).getWidth() / 2);
                break;
            }
            case 3: {
                if (this.getX() + 60 + this.robot.get(0).getWidth() / 2 <= tablero.get_Xescenario()) {
                    this.setX(this.getX() + 60);
                    break;
                }
                this.setX(tablero.get_Xescenario() - this.robot.get(0).getWidth() / 2);
            }
        }
    }

    public int getVelocidad() {
        return this.velocidad;
    }

    public void setVelocidad(int velocidad) {
        this.velocidad = velocidad;
    }

    public void transformarse() {
        this.modificador = this.modificador == 0 ? 4 : 0;
    }

    public int get_Transformacion() {
        return this.modificador;
    }

    public boolean dormido() {
        return this.dormido;
    }

    public void hibernar(long hilo) {
        if (!this.dormido()) {
            this.dormido = true;
            this.hilo = hilo;
        } else if (hilo == this.hilo) {
            this.dormido = false;
            this.hilo = -1L;
        }
    }
}

